/***************************************************************************************
File       : Samples.cpp
Description: How to use st10flasher.dll
Author     : Laurent REGNIER
History    : Creation 08-Mar-2001   
Copyright STMicroelectronics 2001
***************************************************************************************/

#include "stdafx.h" // If using precompiled header 
#include "BasicInterface.h" 

//***************************************************************************************
void main(void)
//***************************************************************************************
{  // Test the programmation of the flash by basic interface
	unsigned int  Flag=1,i=0;
	unsigned long iSize=0; 
	char Target[128]="",BuffError[256]="";
	bool bFlag1=false;
	unsigned int ComSpeed=38400;

	// Init the communication
	// Be carrefull ComSpeed must be a valid speed with SOBRS=0 
	Flag&=(unsigned int) SetCom("com1", ComSpeed);
	if (Flag==0)
	{
		GetError(BuffError);
		printf(BuffError);
		return;
	}

	// Load the monitor and autodetect the target
	Flag&=(unsigned int) InitMonitor(Target);
	if (Flag==0)
	{
		GetError(BuffError);
		printf(BuffError);
		return;
	}
	printf("\nChip found: %s",Target);

	// Change the communication speed 
	ComSpeed=57600; // We change the frequency to a highest one
	Flag&=(unsigned int) SetComSpeed("com1", ComSpeed);
	if (Flag==0)
	{
		GetError(BuffError);
		printf(BuffError);
		return;
	}

	// Load the file to program
	Flag&=(unsigned int) LoadFile("hexfiles\\1390.hex",iSize);
	if (Flag==0)
	{
		GetError(BuffError);
		printf(BuffError);
		return;
	}

	// Set ROMS1 bit regarding the content of the hexfile
	AutoROMS1(bFlag1); // Remap first bank to segment O or 1
	if (GetError(BuffError)!=0)
	{
		printf(BuffError);
	}

	// Get the number of bank
	i= GetNbBlock();
	printf("\nNumber of banks %d :",i);

	// Print size and range for each bank
	for (unsigned int j=0;j<i;++j)
	{
		GetBlockDescription(j,Target);
		printf("\nBank %d :%s",j,Target);
	}

	// Blank check
	i=(unsigned int) BlankCheck();
	printf("\nBlanck bank= %x : ",i);
	GetBlockMaskDescription(i, Target,"bank");
	printf(Target);


	// Test which Banks have to be erased regarding the Hexfile
	i=BlockNbToErase(false);
	printf("\nBanks who have to be erased %x: ",i);
	GetBlockMaskDescription(i, Target,"bk");
	printf(Target);

	// Erase banks not blank
	Flag&=(unsigned int) EraseFlash(i);
	if (Flag==0)
	{
		GetError(BuffError);
		printf(BuffError);
	}

	// Now we can program the flash. Program make also a verify.
	Flag&=(unsigned int) ProgramFlash();
	if (Flag==0)
	{
		GetError(BuffError);
		printf(BuffError);
	}

	// Make another verification ( not compulsory, yet done)
	Flag&=(unsigned int) VerifyFlash(0xFFFF);
	if (Flag==0)
	{
		GetError(BuffError);
		printf(BuffError);
	}

	// Close the com port
	Flag&=(unsigned int) CloseCom();
	if (Flag==0)
	{
		GetError(BuffError);
		printf(BuffError);
	}
}
